function  k = s2k(s,TTM)
%==========================================================================================
%The function converts the sigma of a log-normal distribution to an
%approximated value of k for a Weibull distribution by matching the
%variances of the two log-distributions (normal vs Gumbel)
%INPUT:
%   s: sigma of a lognormal distribution
%   TTM: time to maturity of the options (in years)
%
%OUTPUT:
%   k: k for a Weibull distribution
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 


k = s*sqrt(6)*TTM/pi;

end

